using System;
using System.Windows.Forms;
using System.Collections;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Gui;
using BeWise.SharpBuilderTools.Utils;
using BeWise.SharpBuilderTools;

// TODO Ajouter Static
// TODO Ajouter des tri
namespace BeWise.SharpBuilderTools
{
	public class OTAViewMethods : BaseOTA
	{
		/**************************************************************/
		/*                       Protected
		/**************************************************************/
                                 
		protected void DoViewMethods(object aSender, EventArgs AEventArgs)
		{
			FrmViewMethods _Frm = new FrmViewMethods();
			_Frm.ShowDialog();
		}

		protected void DoGotoPreviousMethod(object aSender, EventArgs AEventArgs)
		{
			ArrayList _List = new ArrayList();
			OTAUtils.LoadMethodInfoInList(_List);

			for (int i = 0; i < _List.Count; i++) {
				MethodInfo _MethodInfo = (MethodInfo) _List[i];

				if (_MethodInfo.CodeMemberMethod.LinePragma.LineNumber >= OTAUtils.GetCurrentLineNumber()) {
					if (i-1 >= 0) {
						_MethodInfo = (MethodInfo) _List[i-1];
						_MethodInfo.Goto();
					}

					return;
				} else if (i == _List.Count -1 && i != 0)   {
					_MethodInfo = (MethodInfo) _List[i];
					_MethodInfo.Goto();
				}
			}
		}

		protected void DoGotoNextMethod(object aSender, EventArgs AEventArgs)
		{
			ArrayList _List = new ArrayList();
			OTAUtils.LoadMethodInfoInList(_List);

			for (int i = 0; i < _List.Count; i++) {
				MethodInfo _MethodInfo = (MethodInfo) _List[i];

				if (_MethodInfo.CodeMemberMethod.LinePragma.LineNumber > OTAUtils.GetCurrentLineNumber()) {
					_MethodInfo.Goto();
					return;
				}
			}
		}

		protected void DoGotoInitializeComponent(object aSender, EventArgs AEventArgs)
		{
			ArrayList _List = new ArrayList();
			OTAUtils.LoadMethodInfoInList(_List);

			for (int i = 0; i < _List.Count; i++) {
				MethodInfo _MethodInfo = (MethodInfo) _List[i];

				if (_MethodInfo.CodeMemberMethod.Name == "InitializeComponent") {
					_MethodInfo.Goto();
					return;
				}
			}
		}

		protected void DoGotoConstructor(object aSender, EventArgs AEventArgs)
		{
			ArrayList _List = new ArrayList();
			OTAUtils.LoadMethodInfoInList(_List);

			for (int i = 0; i < _List.Count; i++) {
				MethodInfo _MethodInfo = (MethodInfo) _List[i];

				if (_MethodInfo.IsConstructor) {
                    _MethodInfo.Goto();
					return;
				}
			}
		}

		/**************************************************************/
		/*                       Public
		/**************************************************************/

		public override void IDERegister(out string[] aMenuNames, out int[] aMenuShortCuts) {
			IOTAMainMenuService _MenuService = null;
			IOTAMenuItem _MenuItem = null;

			_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));

            // View Methods
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "ViewMethodsMenu",
												 "View Methods...");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoViewMethods);

			// Goto Next Method
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "GotoNextMethodMenu",
												 "Go to Next Method");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoGotoNextMethod);

			// Goto Previous Method
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "GotoPreviousMethodMenu",
												 "Go to Previous Method");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoGotoPreviousMethod);

			// Goto InitializeComponents
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "GotoInitializeComponentMenu",
												 "Go to InitializeComponent");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoGotoInitializeComponent);

			// Goto Constructor
			/*
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME, OTAMenuItemLocation.otamlChild, "GotoConstructorMenu", "Go to Constructor");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoGotoConstructor);
			*/

			// Sep1
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_VIEW_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "MethodSep2","-");

			aMenuNames = new string[] {"ViewMethodsMenu", "GotoNextMethodMenu", "GotoPreviousMethodMenu", "GotoInitializeComponentMenu", /*"GotoConstructorMenu"*/};
			aMenuShortCuts = new int[] {16455, 16574, 16572, 49225}; // Ctrl G, Ctrl ., Ctrl , Ctrl ALt I
		}
	}
}
